/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.calendar.AppointmentProviderRegistry;
import de.willuhn.jameica.gui.calendar.ReminderCalendarPart;
import de.willuhn.jameica.gui.internal.action.ReminderAppointmentDetails;
import de.willuhn.jameica.gui.internal.dialogs.AppointmentProviderDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.List;

public class Appointments
extends AbstractView {
    private static Date currentDate = null;
    private ReminderCalendarPart calendar = null;

    @Override
    public void bind() throws Exception {
        I18N i18n = Application.getI18n();
        GUI.getView().setTitle(i18n.tr("Termine"));
        Configure configure = new Configure();
        this.calendar = new ReminderCalendarPart();
        this.calendar.setCurrentDate(currentDate);
        GUI.getView().addPanelButton(new PanelButton("document-properties.png", configure, i18n.tr("Anzuzeigende Kalender ausw\u00e4hlen")));
        List<Plugin> plugins = Application.getPluginLoader().getInstalledPlugins();
        for (Plugin plugin : plugins) {
            List<AppointmentProvider> providers = AppointmentProviderRegistry.getAppointmentProviders(plugin);
            for (AppointmentProvider provider : providers) {
                if (!AppointmentProviderRegistry.isEnabled(provider)) continue;
                this.calendar.addAppointmentProvider(provider);
            }
        }
        this.calendar.paint(this.getParent());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Neuer Termin..."), new ReminderAppointmentDetails(), null, true, "document-new.png");
        buttons.addButton(i18n.tr("Kalender ausw\u00e4hlen..."), configure, null, false, "document-properties.png");
        buttons.paint(this.getParent());
    }

    @Override
    public void unbind() throws ApplicationException {
        if (this.calendar != null) {
            currentDate = this.calendar.getCurrentDate();
        }
    }

    private class Configure
    implements Action {
        private Configure() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            try {
                AppointmentProviderDialog d = new AppointmentProviderDialog(1);
                List selected = (List)d.open();
                Appointments.this.calendar.removeAll();
                for (AppointmentProvider p : selected) {
                    Appointments.this.calendar.addAppointmentProvider(p);
                }
                Appointments.this.calendar.refresh();
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (OperationCanceledException ae) {
            }
            catch (Exception e) {
                Logger.error((String)"unable to configure appointment providers", (Throwable)e);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehlgeschlagen: {0}", e.getMessage()), 1));
            }
        }
    }
}

